/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package se.toel.tellsticknet.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import se.toel.tellsticknet.Event;
import se.toel.event.EventHandler;
import se.toel.util.Closer;
import se.toel.util.Dev;

/**
 *
 * @author Toel
 */
public class Server extends Thread {

    /**************************************************************************
     * Variables
     **************************************************************************/
    private int port = 45002;
    private boolean running = true;
    private OutputStream os = null;

    ServerSocket listener = null;
    TCPIPworker worker = null;

    /**************************************************************************
     * Constructor
     **************************************************************************/
    public Server() {
    }

    /**************************************************************************
     * Public function
     **************************************************************************/
    @Override
    public void run() {

        while (running) {

            try {

                listener = new ServerSocket(port);

                while (running) {
                    worker = new TCPIPworker(listener.accept());
                    worker.start();
                }

            } catch (Exception e) {
                Dev.info(this.getClass().getSimpleName()+": "+e.getClass().getName()+": "+e.getMessage());
                Dev.sleep(1000);
            }

        }

        System.out.print("Shuting down listener");

    }

    public void shutdown() {
        running = false;
        Closer.close(listener);
    }
    
    /** Send some bytes */
    public void send(String s) {

        try {
            worker.send(s.getBytes("ASCII"));
        } catch (Exception e) {
            Dev.error("While sending to TellStick Net:", e);
        }
    }

   

    /**************************************************************************
     * sub class
     **************************************************************************/
    private class TCPIPworker extends Thread {

        Socket socket = null;

        public TCPIPworker(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {

            InputStream is = null;
            byte[] bytes = new byte[1024];
            String lastMsg = null;
            long lastTime = 0;

            try {

                is = socket.getInputStream();
                os = socket.getOutputStream();
                int z = 100;
                
                while (running) {
                    
                    long now = System.currentTimeMillis();
                    
                    if (is.available()>0) {
                    
                        int n = is.read(bytes);
                        if (n>=0) {
                            boolean ok = true;
                            
                            String s = new String(bytes, 0, n, "ASCII");
                            
                            if (s.contains("ss28:")) {
                                String[] ss = s.split("28:");
                                for (String s2 : ss) {
                                    if (s2.contains(":arctech")) {
                                        s = "28:"+s2;                                 // Multiple messages in one row, 
                                        break;                                  // We are only interested in the one using arctech protocol
                                    }          
                                }
                            }
                            
                            if (s.equals(lastMsg)) {
                                ok = ((now-lastTime)>1000);
                            }
                            if (ok) {
                                EventHandler.getInstance().trigger(Event.MSG_RECEIVED_TELLSTICK, s);
                                lastMsg = s;
                                lastTime = now;
                            }

                        }
                        
                    } else {
                        
                        if ((now-lastTime)>120000) {
                            send("28:4df8af148e8cc310c85929fffaf4d3617c8492236:4:pong".getBytes("ASCII"));
                            lastTime = now;
                        }
                        sleep(100);
                    }
                    
                }

            } catch (Exception e) {
                e.printStackTrace();
                Dev.info(e.getClass().getSimpleName()+": "+e.getMessage());
                Closer.close(is);
                Closer.close(os);
            }
        }
        
        /** Send some bytes */
        public void send(byte[] bytes) throws Exception {

            if (os==null) {
                throw new Exception("Server output stream is not open yet");
            }

            os.write(bytes);

        }


        
    }
}
