/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package se.toel.tellsticknet;

import java.util.Map;
import se.toel.tellsticknet.net.Client;
import se.toel.event.EventHandler;
import se.toel.event.EventIF;
import se.toel.event.EventListenerIF;
import se.toel.util.Dev;

/**
 *
 * @author toel
 */
public class LiveHandler implements EventListenerIF {
    
    Client liveClient = null;
    
    
    public LiveHandler(String ip, int port) {
        init(ip, port);
    }
    
    
    @Override
    public void eventTriggered(EventIF event) {
        
        String data = event.getMessage();
        
        if (event.getId()==Event.MSG_RECEIVED_LIVE) {
            Dev.info("RCV LIVE: "+data);
            EventHandler.getInstance().trigger(Event.MSG_SEND_TELLSTICK, data);
        }
        
        if (event.getId()==Event.MSG_SEND_LIVE) {
            Dev.info("SND LIVE: "+data);
            try {
                liveClient.send(data.getBytes("ASCII"));
            } catch (Exception e) {
                Dev.error("While sending message to Live!: ", e);
            }
        }
        
        
    }
    
    public void shutdown() {
        
        liveClient.shutdown();
        
    }
    
    /***************************************************************************
     * private methods
     **************************************************************************/
    private void processMsg28(Map<String, String> msg) {
        
        String id = msg.get("8");
        if (id!=null) {
            processRegistration(msg);
            return;
        }
        
        id = msg.get("7");
        if (id!=null) {
            processMessage(msg);
            return;
        }
        
    }
    
    private void processRegistration(Map<String, String> msg) {
        
        // 28:A4DE4EC2305633477502826F4395A70ACD1B9E2C95:8:Registerh3:key20:SWAQ8THEC2EBA9HEFEJ5RUSTEHEY927T3:macC:ACCA5400023A6:secretA:22PVLJAF8E4:hash4:sha1sh8:protocoli1s7:version1:22:osD:TellStick Nets
        // 28:1a14e7bf6ac3ae5049dc6336e0ea30828b0b06bb25:A:Registeredh10:supportedMethodsi17ss
        String s = "Registration request received:";
        s += "\n   key20  : "+msg.get("key20");
        s += "\n   macC   : "+msg.get("macC"); 
        s += "\n   secretA: "+msg.get("secretA");
        s += "\n   hash4  : "+msg.get("hash4");
        
    }
    
    private void processMessage(Map<String, String> msg) {
        
    }
    
    
    private void init(String ip, int port) {
        
        EventHandler.getInstance().subscribe(Event.MSG_RECEIVED_LIVE, this);
        EventHandler.getInstance().subscribe(Event.MSG_SEND_LIVE, this);
        
        liveClient = new Client("79.99.3.85", 45002);
        liveClient.start();
    }
    
}
