/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package se.toel.tellsticknet.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import se.toel.tellsticknet.Event;
import se.toel.event.EventHandler;
import se.toel.event.EventIF;
import se.toel.event.EventListenerIF;
import se.toel.util.Closer;
import se.toel.util.Dev;

/**
 *
 * @author Toel
 */
public class Client extends Thread {

    /**************************************************************************
     * Variables
     **************************************************************************/
    private int port = 0;
    private String host = null;
    private boolean running = false;

    OutputStream os = null;
    

    /**************************************************************************
     * Constructor
     **************************************************************************/
    public Client(String host, int port) {
        this.host = host;
        this.port = port;
    }

    /**************************************************************************
     * Public function
     **************************************************************************/
    @Override
    public void run() {

        InputStream is = null;
        byte[] bytes = new byte[1024];

        try {

            running = true;
            Socket socket = new Socket(host, port);
            
            while (running) {

                
                os = socket.getOutputStream();
                is = socket.getInputStream();
                

                int n = is.read(bytes);
                while (n>=0) {
                    String s = new String(bytes, 0, n, "ASCII");
                    EventHandler.getInstance().trigger(Event.MSG_RECEIVED_LIVE, s);
                    n = is.read(bytes);
                }
            }

        } catch (Exception e) {
            Dev.info(e.getClass().getSimpleName()+": "+e.getMessage());
            Closer.close(is);
            Closer.close(os);
        }
        

    }

    public void shutdown() {
        running = false;
        Closer.close(os);
    }

    

    /** Send some bytes */
    public void send(byte[] bytes) throws Exception {

        if (os==null) {
            throw new Exception("Client output stream is not open yet");
        }

        os.write(bytes);
        
    }


}
