/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package se.toel.tellsticknet;

import org.junit.*;
import static org.junit.Assert.*;
import se.toel.event.EventHandler;
import se.toel.event.EventIF;
import se.toel.event.EventListenerIF;
import se.toel.util.Dev;
import se.toel.util.IniFile;
import se.toel.util.StringUtil;

/**
 *
 * @author toel
 */
public class ServerTest implements EventListenerIF {
    
    public ServerTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }
    
    @Before
    public void setUp() {
    }
    
    @After
    public void tearDown() {
    }

    /**
     * Test of start method, of class Server.
     */
    @Test
    public void testStart() {
        
        IniFile ini = new IniFile("./test/JavaTellStickNet.ini");
        
        boolean proxyMode = ini.getValue("TelldusLive", "Proxy", "False").equalsIgnoreCase("True");
        
        Server server = new Server(proxyMode);
        server.setLiveIp(ini.getValue("TelldusLive", "IP", "79.99.3.85"));
        server.setLivePort(StringUtil.str2int(ini.getValue("TelldusLive", "Port", "45002")));
        
        // Start the server
        server.start();
        
        // Register event listener
        EventHandler.getInstance().subscribe(Event.TELLSTICK_EVENT, this);
       
        // Run for 1 minute
        long start = System.currentTimeMillis();
        while (server.isRunning()) {
            Dev.sleep(100);
            if ((System.currentTimeMillis()-start)>60000) break;
        }
        
        server.shutdown();
        
    }

    @Override
    public void eventTriggered(EventIF event) {
        Dev.info(event.getMessage());
    }

}
