/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package se.toel.tellsticknet;

import se.toel.util.Dev;
import se.toel.util.StringUtil;

/*
 * * A command to a remote unit is 12 bits long. The bits are sent in reverse order (low to high) and in the order house (4 bits), channel (4 bits) and command (4 bits). Command is somewhat special as bit 1 is zero, bit 2 and 3 in the block have to be ones, while the command is stored in bit 4. (i.e. in the normal order command is always 011X, where X is one for "one" and zero for "off")

House is given as A-P (numerical value 0-15) channel is given as 1-16 (numerical value 0-15)

In the string that is sent the following is applied: The string is started out with the character "S", the bit string is then sent with the string " " for a one, the string " " for a zero and is ended with the character "}+".

Example: House C, channel 5 and the command "on", leads to numerical house = 2, channel = 4 and command = 1. Bit pattern: (command)1110 (channel)0100 (house)0010. As we have to send them in reverse order the pattern to send is: 010000100111

After conversion to strings for one/zero we retrieve:


 */


/**
 *
 * @author toel
 */
public class Server {
    
    boolean running = true;
    TellStickHandler tellStickHandler = null;
    LiveHandler liveHandler = null;
    boolean liveProxy = false;
    
    private String liveIp = "79.99.3.85";
    private int livePort  = 45002;
    
    public Server(boolean liveProxy) {
        
        // Shutdown hook to close the db connection
        Runtime.getRuntime().addShutdownHook( new Thread (  )  {  
            @Override
            public void run() {
                shutdown();
            }
        }); 
        
        this.liveProxy = liveProxy;
        
    }
    
    public void start() {
        
        try { 
            
            Dev.info("Starting telldus listener on port 45002");
            tellStickHandler = new TellStickHandler(liveProxy);
            
            if (liveProxy) {
                Dev.info("Starting live! proxy client");
                if (livePort==0) livePort=45002;
                liveHandler = new LiveHandler(liveIp, livePort);
            }
        
        } catch (Exception e) {
            Dev.error("Oops!", e);
        }
        
    }
    
    public void shutdown() {
        
        Dev.info("Shutting down...");
        if (tellStickHandler!=null) tellStickHandler.shutdown();
        if (liveHandler!=null) liveHandler.shutdown();
        running = false;
        
    }
    
    
    public boolean isRunning() {
        return running;
    }

    /**
     * @return the liveIp
     */
    public String getLiveIp() {
        return liveIp;
    }

    /**
     * @param liveIp the liveIp to set
     */
    public void setLiveIp(String liveIp) {
        this.liveIp = liveIp;
    }

    /**
     * @return the livePort
     */
    public int getLivePort() {
        return livePort;
    }

    /**
     * @param livePort the livePort to set
     */
    public void setLivePort(int livePort) {
        this.livePort = livePort;
    }

    
    
}
