/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package se.toel.tellsticknet;

import java.util.HashMap;
import java.util.Map;
import se.toel.tellsticknet.net.Server;
import se.toel.event.EventHandler;
import se.toel.event.EventIF;
import se.toel.event.EventListenerIF;
import se.toel.util.ConfigProperties;
import se.toel.util.Dev;
import se.toel.util.StringUtil;

/**
 *
 * @author toel
 */
public class TellStickHandler implements EventListenerIF {
    
    Server telldus = null;
    //ConfigProperties config = new ConfigProperties("conf", "", "tellStickHandler");
    boolean proxyMode = false;
    boolean echo = false;
    
    public TellStickHandler(boolean proxyMode) {
        this.proxyMode = proxyMode;
        init();
    }
    
    
    @Override
    public void eventTriggered(EventIF event) {
        
        String data = event.getMessage();
        
        if (event.getId()==Event.MSG_RECEIVED_TELLSTICK) {

            if (echo) Dev.info("RCV TELL: "+data);
            
            // Echo messages to the Live server (does not matter if is not running or not)
            EventHandler.getInstance().trigger(Event.MSG_SEND_LIVE, data);

            if (!proxyMode) {
                boolean processed = false;

                Map<String, String> msg = parseData(data);

                if (msg.containsKey("28")) {
                    processMsg28(msg);
                    processed = true;
                }

                if (!processed) {
                    if (echo) Dev.info("Not handled: "+data);
                }
            }
        }
        
        if (event.getId()==Event.MSG_SEND_TELLSTICK) {
            sendData(data);
        }
    }
    
    public void shutdown() {
        
        //config.save();
        telldus.shutdown();
        
    }
    
    public String processPing(Map<String, String> msg) {
        
        // 28:DB4950A3E0D9240CCA2AF399F11F13D6CC27EB5406:4:Ping
        // 28:4df8af148e8cc310c85929fffaf4d3617c8492236:4:pong
        Dev.info("Ping request received. Answering with Pong.");
        sendData("28:4df8af148e8cc310c85929fffaf4d3617c8492236:4:pong");
        
        return("OK");
        
    }
    
    public String processRegistration(Map<String, String> msg) {
        
        // 28:A4DE4EC2305633477502826F4395A70ACD1B9E2C95:8:Registerh3:key20:SWAQ8THEC2EBA9HEFEJ5RUSTEHEY927T3:macC:ACCA5400023A6:secretA:22PVLJAF8E4:hash4:sha1sh8:protocoli1s7:version1:22:osD:TellStick Nets
        // 28:1a14e7bf6ac3ae5049dc6336e0ea30828b0b06bb25:A:Registeredh10:supportedMethodsi17ss
        Dev.info("Registration request received. Answering positively.");
        sendData("28:1a14e7bf6ac3ae5049dc6336e0ea30828b0b06bb25:A:Registeredh10:supportedMethodsi17ss");
        
        return("OK");
        
    }
    
    public String processReceived(String s) {
        
        Dev.info("Received: "+s);
        return("OK");
        
    }
    
    
    
    /***************************************************************************
     * private methods
     **************************************************************************/
    private void processMsg28(Map<String, String> msg) {
        
        if (msg.containsKey("4")) {
            processPing(msg);
        } else if (msg.containsKey("8")) {
            processRegistration(msg);
        } else if (msg.containsKey("7")) {
            processMessage(msg);
        } else {
            Dev.warn("Unhandled message: "+msg.toString());
        }
        
    }
    
    private void sendData(String data) {
        if (echo) Dev.info("SND TELL: "+data);
        telldus.send(data);
    }
    
    
    // Here we go!
    private void processMessage(Map<String, String> msg) {
        
        String c = msg.get("data");
        c = decodeMessage(c);
        
        if (c!=null) EventHandler.getInstance().trigger(Event.TELLSTICK_EVENT, c);
           
    }
    
    
    private Map<String, String> parseData(String s) {
        
        Map<String, String> msg = new HashMap<String, String>();
        
        String[] parts = s.split(":");
        int n = parts.length;
        
        for (int i=0; i<n/2; i++) {
            msg.put(parts[i*2], parts[i*2+1]);
        }
        
        if (n%2>0) msg.put("data", StringUtil.getBetween(parts[n-1], "datai", "ss"));
        
        return msg;
        
    }
    
    private void init() {
        
        EventHandler.getInstance().subscribe(Event.MSG_RECEIVED_TELLSTICK, this);
        EventHandler.getInstance().subscribe(Event.MSG_SEND_TELLSTICK, this);
        
        telldus = new Server();
        telldus.start();
        
        //config.setFunctionProvider("TellStickHandler", this);
    }
    
    
    private String decodeMessage(String data) {
        
        String value = null;
        
        if (data==null) return null;
        
        /*     A command to a remote unit is 12 bits long. The bits are sent in reverse order (low to high) and in the order house (4 bits), channel (4 bits) and command (4 bits). 
         * Command is somewhat special as bit 1 is zero, bit 2 and 3 in the block have to be ones, while the command is stored in bit 4. (i.e. in the normal order command is always 011X, where X is one for "one" and zero for "off") 

House is given as A-P (numerical value 0-15) channel is given as 1-16 (numerical value 0-15)

In the string that is sent the following is applied: The string is started out with the character "S", the bit string is then sent with the string " " for a one, the string " " for a zero and is ended with the character "}+".

Example: House C, channel 5 and the command "on", leads to numerical house = 2, channel = 4 and command = 1. Bit pattern: (command)1110 (channel)0100 (house)0010. As we have to send them in reverse order the pattern to send is: 010000100111

After conversion to strings for one/zero we retrieve: 
* */
        /*
        int n=15;
        if (v>65535) n=31;
        //E33=111000110011
        for (int i=n; i>=0; i--) {
            int m = (1 << i);
            if ((v & m)>0) {
                sb.append("1");
            } else {
                sb.append("0");
            }
        }*/
        
        long v = Long.parseLong(data, 16);
        String binary = Long.toBinaryString(v);
        
        if (v==0){
            return null;
            
        } else if (v<65536) {
            
            //binary = StringUtil.fixLength(binary, 12);
            
            // command
            long cmd = 0xF & (v >> 8);
            if ((cmd & 7)!=6) {
                Dev.warn("Wrong package!");
                return null;
            }
            String sCmd = "Off";
            if ((cmd & 8)>0) sCmd = "On";
            
            // Channel
            long channel = 0xF & (v >> 4);
            channel+=1;
            
            // House
            long house = 0xF & v;
            char cHouse = (char) (house+65);
            
            value = cHouse + " " + channel + " " + sCmd;
            
        } else {
            return null;
        }
        
        return value;
        
    }
    
}
